/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.common.item.routing;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkHooks;
import wayoftime.bloodmagic.common.item.inventory.InventoryFilter;
import wayoftime.bloodmagic.common.item.routing.BasicFilterKey;
import wayoftime.bloodmagic.common.item.routing.IFilterKey;
import wayoftime.bloodmagic.common.item.routing.ItemCompositeFilter;
import wayoftime.bloodmagic.util.GhostItemHelper;
import wayoftime.bloodmagic.util.Utils;

public class ItemStandardFilter
extends ItemCompositeFilter {
    @Override
    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (!world.f_46443_) {
            Utils.setUUID(stack);
            if (player instanceof ServerPlayer) {
                NetworkHooks.openGui((ServerPlayer)((ServerPlayer)player), (MenuProvider)this, buf -> buf.writeItemStack(stack, false));
            }
        }
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack filterStack, Level world, List<Component> tooltip, TooltipFlag flag) {
        int whitelistState;
        boolean isWhitelist;
        tooltip.add((Component)new TranslatableComponent("tooltip.bloodmagic.basicfilter.desc").m_130940_(ChatFormatting.ITALIC).m_130940_(ChatFormatting.GRAY));
        if (filterStack.m_41783_() == null) {
            return;
        }
        List<ItemStack> nestedFilters = this.getNestedFilters(filterStack);
        if (nestedFilters.size() > 0) {
            boolean sneaking = Screen.m_96638_();
            if (!sneaking) {
                tooltip.add((Component)new TranslatableComponent("tooltip.bloodmagic.extraInfo").m_130940_(ChatFormatting.BLUE));
            } else {
                tooltip.add((Component)new TranslatableComponent("tooltip.bloodmagic.contained_filters").m_130940_(ChatFormatting.BLUE));
                for (ItemStack nestedStack : nestedFilters) {
                    tooltip.add(nestedStack.m_41786_());
                }
            }
        }
        boolean bl = isWhitelist = (whitelistState = this.getCurrentButtonState(filterStack, "blackwhitelist", 0)) == 0;
        if (isWhitelist) {
            tooltip.add((Component)new TranslatableComponent("tooltip.bloodmagic.filter.whitelist").m_130940_(ChatFormatting.GRAY));
        } else {
            tooltip.add((Component)new TranslatableComponent("tooltip.bloodmagic.filter.blacklist").m_130940_(ChatFormatting.GRAY));
        }
        InventoryFilter inv = new InventoryFilter(filterStack);
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack stack = inv.m_8020_(i);
            if (stack.m_41619_()) continue;
            if (isWhitelist) {
                int amount = GhostItemHelper.getItemGhostAmount(stack);
                if (amount > 0) {
                    tooltip.add((Component)new TranslatableComponent("tooltip.bloodmagic.filter.count", new Object[]{amount, stack.m_41786_()}));
                    continue;
                }
                tooltip.add((Component)new TranslatableComponent("tooltip.bloodmagic.filter.all", new Object[]{stack.m_41786_()}));
                continue;
            }
            tooltip.add(stack.m_41786_());
        }
    }

    @Override
    public IFilterKey getFilterKey(ItemStack filterStack, int slot, ItemStack ghostStack, int amount) {
        return new BasicFilterKey(ghostStack, amount);
    }
}

